<?php
include 'connection.php';

if (isset($_POST['user_id']) || isset($_POST['test_id'])) {
    $conn->begin_transaction();
    try {
        if (isset($_POST['test_id'])) {
            // Delete a specific test record by test_id
            $test_id = intval($_POST['test_id']);
            $deleteTestSql = "DELETE FROM test_results WHERE id = ?";
            $stmt = $conn->prepare($deleteTestSql);
            $stmt->bind_param('i', $test_id);
        } elseif (isset($_POST['user_id'])) {
            // Delete all test records for a user by user_id
            $user_id = intval($_POST['user_id']);
            $deleteResultsSql = "DELETE FROM test_results WHERE user_id = ?";
            $stmt = $conn->prepare($deleteResultsSql);
            $stmt->bind_param('i', $user_id);
        }

        $stmt->execute();
        $conn->commit();
        echo json_encode(['success' => true, 'message' => 'Test record(s) deleted successfully.']);
    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(['success' => false, 'message' => 'Failed to delete test record(s).']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request.']);
}
?>
