<?php
// Include the database connection file
include 'connection.php';

// Check if the connection was successful
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "Database connection failed: " . $conn->connect_error]);
    exit();
}

// Check if user_id is provided in POST data
if (isset($_POST['user_id'])) {
    $user_id = (int)$_POST['user_id']; // Cast to integer for safety

    // Check if the user exists in the `user_profile` table
    $checkUserSql = "SELECT * FROM user_profile WHERE user_id = '$user_id'";
    $result = $conn->query($checkUserSql);

    if ($result->num_rows > 0) {
        // Start a transaction to ensure data integrity
        $conn->begin_transaction();

        try {
            // Delete user from `user_profile` table
            $deleteUserSql = "DELETE FROM user_profile WHERE user_id = '$user_id'";
            if ($conn->query($deleteUserSql) === TRUE) {
                // Commit the transaction after successful deletion
                $conn->commit();
                echo json_encode(["status" => "success", "message" => "User account deleted successfully"]);
            } else {
                // Rollback transaction if user deletion fails
                throw new Exception("Error deleting user: " . $conn->error);
            }
        } catch (Exception $e) {
            // Rollback transaction on exception
            $conn->rollback();
            echo json_encode(["status" => "error", "message" => "Transaction failed: " . $e->getMessage()]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "User with the provided ID does not exist."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Missing user_id parameter."]); // Missing parameter
}

// Close the database connection
$conn->close();
?>
