<?php
// upload_image.php
include 'connection.php'; // Include your DB connection (optional, depending on your needs)

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_FILES['image']) && $_FILES['image']['error'] == UPLOAD_ERR_OK) {
        $imageTmpPath = $_FILES['image']['tmp_name'];
        $imageName = basename($_FILES['image']['name']);
        $uploadDir = 'uploads/'; // Folder where you want to store the image

        // Check if the upload directory exists
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true); // Create the directory if it doesn't exist
        }

        // Generate a unique filename
        $newImageName = uniqid() . '_' . $imageName;

        // Move the image to the upload directory
        if (move_uploaded_file($imageTmpPath, $uploadDir . $newImageName)) {
            // Dynamically get the server IP address
            $serverIp = '192.168.1.6'; // Replace this with your static IP if necessary
            $imageUrl = "http://$serverIp/prsonality_tester/$uploadDir$newImageName";

            // Return the image URL in the response
            echo json_encode(["imageUrl" => $imageUrl]);
        } else {
            echo json_encode(["error" => "Error uploading image."]);
        }
    } else {
        echo json_encode(["error" => "No image file or upload error."]);
    }
} else {
    echo json_encode(["error" => "Invalid request method."]);
}

$conn->close(); // Close the database connection if you are using it
?>
